import { View, Text } from "react-native";
import React from "react";
import { itemDetailsStyles } from "../ItemDetailsStyle";
import dpr from "../../../../../Utilities/CustomStyleAttribute/dpr";
import StarIcon from "../../../../../../assets/svgs/product details/Star.svg";
import useLangTranslation from "../../../../../../hooks/useLangTranslation";
import CustomSVG from "../../../../../../src/components/CustomSVG/CustomSVG";

const ItemHeader = ({ data }) => {
    const {trans} = useLangTranslation();
    const { name, categories, reviews_allowed, review_average } = data || {};
    return (
        <>
            <View style={itemDetailsStyles.ratingCont}>
                {categories?.length > 0 && (
                    <Text style={itemDetailsStyles.nameText}>
                        {trans(categories[0])}
                    </Text>
                )}
                {reviews_allowed == 1 && (
                    <View style={itemDetailsStyles.rating}>
                        {review_average ? 
                        <>
                            <CustomSVG svgIcon={StarIcon}
                                height={dpr(13)}
                                width={dpr(13)}
                                fill={"#FCCA19"}
                            />
                            <Text
                                style={[
                                    itemDetailsStyles.ratingText,
                                    itemDetailsStyles.nameText,
                                ]}
                            >
                                {Number(review_average).toFixed(1)}
                            </Text>
                        </> : null}
                    </View>
                )}
            </View>
            {name ? <Text style={itemDetailsStyles.title}>{name}</Text> : null}
        </>
    );
};

export default ItemHeader;
